import java.awt.Frame;
import java.awt.Button;
import java.awt.Panel;
import java.awt.Scrollbar;
import graphics.Slider;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.Font;
import java.awt.Event;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.BorderLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Dimension;
import java.awt.Insets;
import java.lang.Math;
import types.DataClass;


public class ReceiverPanel extends MenuPanel {
	public Computer	  		m_Computer;
	public WheelInfoPanel	m_rwPanel;
	public BucketPanel      m_Buffer;
	protected TextArea      m_Message;
	public ReceiverPanel(Computer computer)	{
		super();
		// create property dialog
		m_Dlg = Global.m_dlgComputerProperties;

		m_Computer = computer;
		setLayout(new BorderLayout(15,15));
		ImagePanel ci =	new	ImagePanel(m_Computer.m_Image);
		ReceiverControl cp	= new ReceiverControl(m_Computer);
		m_rwPanel =	new	WheelInfoPanel(m_Computer.protocol().receiveWindow);
		m_Buffer = new BucketPanel(m_Computer.protocol().m_Buffer2,40,50);
		m_Message = new TextArea(2,10);
		add("Center",ci);
		add("South",cp);
		add("East",m_rwPanel);
        Panel p = new Panel();
        p.setLayout(new BorderLayout(0,20));
        p.add("Center",m_Buffer);
        p.add("North",new Label("Buffer",Label.LEFT));
        add("West",p);
        add("North",m_Message);
	}
	public void	paint(Graphics g) {
		Rectangle frame=bounds();
//		g.drawRect(0,0,frame.width-1,frame.height-1);
	}
	public void	redisplay(DataClass	sw,DataClass rw) {
		m_rwPanel.myUpdate(rw);
		m_Message.setText(m_Computer.m_ReceivePool.toString());
		m_Buffer.myUpdate(m_Computer.protocol().m_Buffer2);
	}
}



class ReceiverSlider extends	Slider {
	Computer	m_Computer;
	int			m_iOldValue;
	public ReceiverSlider(Computer computer)	{
		m_Computer = computer;
		m_iOldValue	= 0;
	}
	protected void Motion()	{
		m_Computer.setSpeed(GetValue());
		m_iOldValue	= GetValue();
	}
}


class ReceiverControl extends Panel {
	Computer	m_Computer;
	Button		m_nextStep;
	ReceiverSlider m_ControlSlider;
	public ReceiverControl(Computer computer) {
		m_Computer = computer;
		// use GridbagLayoutmanager
		GridBagLayout gbl =	new	GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();
		setLayout(gbl);
		// ####### Insert first	row	#######
		// Create Objects
		m_nextStep = new Button("Step");
		m_ControlSlider	= new ReceiverSlider(m_Computer);
		m_ControlSlider.SetHeight(30);
		m_ControlSlider.SetWidth(100);
		m_ControlSlider.SetMinimum(0);
		m_ControlSlider.SetMaximum(100);
		m_ControlSlider.SetValue(0);
		ImagePanel imgPanel	= new ImagePanel(Global.m_imgReceiveSpeed);
		// Set layout of Objects
		// Image
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.insets = new Insets(0,0,0,0);
		gbc.gridwidth =	1;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(imgPanel,gbc);
		add(imgPanel);
		// Slider
		gbc.insets = new Insets(0,5,0,5);
		gbc.gridwidth =	1;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(m_ControlSlider,gbc);
		add(m_ControlSlider);
		// Button
		gbc.insets = new Insets(0,0,0,0);
		gbc.gridwidth =	GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.NONE;
		gbl.setConstraints(m_nextStep,gbc);
		add(m_nextStep);
	}
	public boolean action(Event e,Object what)	{
		if ((e.target == m_nextStep)) {
			if (m_ControlSlider.GetValue()==0) {
				m_Computer.upperLayerReceive();
			}
		}
		return(true);
	}
}

